IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CPJ_Balance_Sumas_Saldos_Rpt]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CPJ_Balance_Sumas_Saldos_Rpt] 
END
GO

Create PROCEDURE [dbo].[CPJ_Balance_Sumas_Saldos_Rpt]	@pJson VARCHAR(8000)
AS

SET NOCOUNT ON

/*Variables recibidas por parametro a traves del JSON*/
DECLARE @pModoDebug			    		TINYINT
DECLARE @pId_Usuario					SMALLINT
DECLARE @pFecha_Desde					DATETIME
DECLARE @pFecha_Hasta					DATETIME
DECLARE @pFlag_incluirSoloAsientos		TINYINT
DECLARE @pFlag_FiltrarId_CC				TINYINT
DECLARE @pId_Centro_Costo				CHAR(10)
DECLARE @pId_Plan_Cta					INT
DECLARE @pId_Unid_Negocio				CHAR(10)
DECLARE @pFlag_Desglozar_CC	    		TINYINT
DECLARE @pFlag_Excluir_Asientos_Cierre	TINYINT
DECLARE @pId_Alias_Cta_Contable			INT

SET @pModoDebug						= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Usuario					= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Usuario')), 0)
SET @pFecha_Desde					= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Desde')), '19000101')
SET @pFecha_Hasta					= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Hasta')), '19000101')
SET @pFlag_incluirSoloAsientos		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Flag_incluirSoloAsientos')), 0)
SET @pFlag_FiltrarId_CC				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Flag_FiltrarId_CC')), 0)
SET @pId_Centro_Costo				= ISNULL(CONVERT(Char(10), dbo.CF_JSON_VALUE(@pJson,'Id_Centro_Costo')), '')
SET @pId_Plan_Cta					= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Plan_Cta')), 0)
SET @pId_Unid_Negocio				= ISNULL(CONVERT(CHAR(10), dbo.CF_JSON_VALUE(@pJson,'Id_Unid_Negocio')), '')
SET @pFlag_Desglozar_CC				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Flag_Desglozar_CC')), 0)
SET @pFlag_Excluir_Asientos_Cierre	= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Flag_Excluir_Asientos_Cierre')), 0)
SET @pId_Alias_Cta_Contable			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Alias_Cta_Contable')), 0)
/*FIN Variables recibidas por parametro a traves del JSON*/

/*Variables Locales*/
DECLARE @SqlStr						NVARCHAR(MAX)
DECLARE @TipoAsientoCierre			VARCHAR(8000)
DECLARE @Id_Cta_Contable			INT
DECLARE @Debe_Suma					DECIMAL(30,2)
DECLARE @Haber_Suma					DECIMAL(30,2)
DECLARE @Nro_Cta_Contable			VARCHAR(20)
DECLARE @Alias						DECIMAL(12,0)
DECLARE @Cta_Contable				VARCHAR(80)
DECLARE @Id_Centro_Costo			CHAR(10)
DECLARE @Centro_Costo				VARCHAR(200)
DECLARE @Anterior					DECIMAL(30,2)
DECLARE @Debe						DECIMAL(30,2)
DECLARE @Haber						DECIMAL(30,2)
DECLARE @Diferencia					DECIMAL(30,2)
DECLARE @Deudor						DECIMAL(30,2)
DECLARE @Acreedor					DECIMAL(30,2)
DECLARE @Columna_Bal				INT
DECLARE @Alias_Cta_Padre			DECIMAL(12,0)
DECLARE @PCE_Fecha_Inicio			DATETIME
DECLARE @PCE_Fecha_Cierre			DATETIME
DECLARE @Id_Ejercicio				INT
DECLARE @Flag_Existe_Registro_En_Cola TINYINT
/*FIN Variables Locales*/


BEGIN TRY
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Balance_Sumas_Saldos_Rpt'
		PRINT 'Parametros: '
		PRINT '@pId_Usuario: ' + CONVERT(VARCHAR(10), @pId_Usuario) + '. @pFecha_Desde: ' + CONVERT(VARCHAR(10), @pFecha_Desde, 112) + '. @pFecha_Hasta: ' + CONVERT(VARCHAR(10), @pFecha_Hasta, 112) +'. @pFlag_FiltrarId_CC: ' + CONVERT(VARCHAR(10), @pFlag_FiltrarId_CC) + '. @pId_Centro_Costo: ' + CONVERT(VARCHAR(10), @pId_Centro_Costo)
		PRINT '@pFlag_incluirSoloAsientos: ' + CONVERT(VARCHAR(10), @pFlag_incluirSoloAsientos) + '. @pId_Plan_Cta: ' + CONVERT(VARCHAR(10), @pId_Plan_Cta) + '. @pId_Unid_Negocio: ' + @pId_Unid_Negocio + '. @pFlag_Desglozar_CC: ' + CONVERT(VARCHAR(10), @pFlag_Desglozar_CC) + '. @pFlag_Excluir_Asientos_Cierre: ' + CONVERT(VARCHAR(10), @pFlag_Excluir_Asientos_Cierre) 
	END

	/*=============================================================================================================================*/
	/*=============================================================================================================================*/

	IF(@pId_Usuario = 0)
	BEGIN
		SET @pId_Usuario = -1
	END
	
	IF(@pFecha_Desde = '19000101')								RAISERROR ('Fecha_Desde can not be blank.', 16,  1)
	IF(@pFecha_Hasta = '19000101')								RAISERROR ('Fecha_Hasta can not be blank.', 16,  1) 
	IF(@pFecha_Desde >= @pFecha_Hasta)							RAISERROR ('Fecha_Desde can not be bigger or equal than Fecha_Hasta.', 16,  1) 
	--IF(DATEDIFF(YEAR, @pFecha_Desde, @pFecha_Hasta) > 0)		RAISERROR ('Diference between Fecha_Desde and Fecha_Hasta can not be bigger than a year.', 16,  1) 	
	IF(@pId_Plan_Cta = 0)										RAISERROR ('Id_Plan_Cta can not be zero.', 16,  1) 
	IF(@pFlag_FiltrarId_CC <> 0)
	BEGIN
		IF(@pId_Centro_Costo = '')								RAISERROR ('ID_Centro_Costo can not be blank.', 16,  1)
	END
	
	/*=============================================================================================================================*/

	SET @TipoAsientoCierre = dbo.CF_xParam('Tipo_Asto_Cierre')
	SELECT 	@Id_Ejercicio	= ISNULL(Id_Ejercicio, 0) 	FROM Plan_Ctas 	WHERE 	Id_Plan_Cta = @pId_Plan_Cta

	SELECT 	@PCE_Fecha_Inicio = ISNULL(Fecha_Inicio, '19000101'),
			@PCE_Fecha_Cierre = ISNULL(Fecha_Cierre, '19000101')
			FROM Plan_Ctas_Ejercicios WHERE Id_Ejercicio = @Id_Ejercicio

	/*=============================================================================================================================*/
    Update Cbtes_Ctas_Contables  set Id_Centro_Costo = '' where Id_centro_costo is null
	Update Asientos_Items  set Id_Centro_Costo = '' where Id_centro_costo is null

	/*=============================================================================================================================*/
	/*=============================================================================================================================*/

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
		PRINT 'ASIENTOS'
	END

    Select Id_Cta_Contable,Id_Centro_Costo into  #Asientos_Sumas_Saldos FROM  Asientos_Items where 1=0

	ALTER TABLE #Asientos_Sumas_Saldos ADD
	            Saldo_Ant						DECIMAL(30,2),
				Debe_Suma						DECIMAL(30,2),
				Haber_Suma						DECIMAL(30,2)


    Select Id_Cta_Contable,Id_Centro_Costo into  #Asientos_Sumas_Saldos_ANTERIOR FROM  Asientos_Items where 1=0
	ALTER TABLE #Asientos_Sumas_Saldos_ANTERIOR ADD 
		        Saldo_Ant						DECIMAL(30,2),
				Debe_Suma						DECIMAL(30,2),
				Haber_Suma						DECIMAL(30,2)

	/*========================================================Saldos de asientos =====================================================================*/

	SET @SqlStr = 'INSERT INTO #Asientos_Sumas_Saldos (Id_Cta_Contable, Id_Centro_Costo, Saldo_Ant, Debe_Suma, Haber_Suma) '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr))												+ CHAR(13) + 
					'SELECT '															+ CHAR(13) + 
					'Id_Cta_Contable, '													+ CHAR(13) 
	IF (@pFlag_Desglozar_CC = 0)	
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) +		
					''''' AS Id_Centro_Costo, '															+ CHAR(13)  
	ELSE
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) +		
					'I.Id_Centro_Costo , '				+ CHAR(13) 

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + 
	                '0 as Saldo_Ant, '									        		+ CHAR(13) + 
					'SUM(ISNULL(I.Debe,0)), '											+ CHAR(13) + 
					'SUM(ISNULL(I.Haber,0)) '											+ CHAR(13) + 
					'FROM Asientos_Items I, Asientos A '								+ CHAR(13) + 
					'WHERE '															+ CHAR(13) + 
					'A.Id_Asiento = I.Id_Asiento '										+ CHAR(13) + 
					'AND A.Balanceado = 1 '												+ CHAR(13) + 
					'AND A.Id_Plan_Cta = '	+ CONVERT(VARCHAR(10), @pId_Plan_Cta)

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND A.Fecha >= ''' + CONVERT(VARCHAR(10), @pFecha_Desde, 112) + ''' '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND A.Fecha < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @pFecha_Hasta), 112) + ''' '

	IF(@pFlag_FiltrarId_CC <> 0)
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND I.Id_Centro_Costo = ''' + @pId_Centro_Costo + ''' '
	END

	IF(@pId_Unid_Negocio <> '')
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND A.Id_Unid_Negocio = ''' + @pId_Unid_Negocio + ''' '
	END

	IF(@pFlag_Excluir_Asientos_Cierre <> 0)
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND A.Id_Tipo_Asi NOT IN (' + @TipoAsientoCierre + ') '
	END

	IF(@pId_Alias_Cta_Contable <> 0)
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND I.Id_Alias_Cta_Cont = ' + CONVERT(VARCHAR(10), @pId_Alias_Cta_Contable) + ' '
	END

	IF (@pFlag_Desglozar_CC = 0)
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) +
						'GROUP BY Id_Cta_Contable ORDER BY Id_Cta_Contable'
	ELSE
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) +
						'GROUP BY Id_Cta_Contable,Id_Centro_Costo ORDER BY Id_Cta_Contable,Id_Centro_Costo  '

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
		PRINT 'Saldos de asientos @SqlStr: '
		PRINT @SqlStr
		PRINT ''
	END

	EXECUTE sp_executesql @SqlStr

--	SELECT * FROM #Asientos_Sumas_Saldos

	/*============================ Saldos anteriores de asientos =====================================================================*/

	SET @SqlStr = 'INSERT INTO #Asientos_Sumas_Saldos_ANTERIOR (Id_Cta_Contable, Id_Centro_Costo, Saldo_Ant, Debe_Suma, Haber_Suma) '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr))												+ CHAR(13) + 
					'SELECT '															+ CHAR(13) + 
					'Id_Cta_Contable, '													+ CHAR(13) 
	IF (@pFlag_Desglozar_CC = 0)	
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) +		
					''''' AS Id_Centro_Costo, '															+ CHAR(13)  
	ELSE
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) +		
					'I.Id_Centro_Costo , '				+ CHAR(13) 

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + 
					'SUM(ISNULL(I.Debe,0)-ISNULL(I.Haber,0)) as saldo_Ant, '			+ CHAR(13) + 
					'0 as Debe_Suma,'		    				+ CHAR(13) + 
					'0 as Haber_Suma'		    				+ CHAR(13) + 
					'FROM Asientos_Items I, Asientos A '								+ CHAR(13) + 
					'WHERE '															+ CHAR(13) + 
					'A.Id_Asiento = I.Id_Asiento '										+ CHAR(13) + 
					'AND A.Balanceado = 1 '												+ CHAR(13) + 
					'AND A.Id_Plan_Cta = '	+ CONVERT(VARCHAR(10), @pId_Plan_Cta)

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND A.Fecha < ''' + CONVERT(VARCHAR(10), @pFecha_Desde, 112) + ''' '


	IF(@pFlag_FiltrarId_CC <> 0)
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND I.Id_Centro_Costo = ''' + @pId_Centro_Costo + ''' '
	END

	IF(@pId_Unid_Negocio <> '')
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND A.Id_Unid_Negocio = ''' + @pId_Unid_Negocio + ''' '
	END

	IF(@pFlag_Excluir_Asientos_Cierre <> 0)
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND A.Id_Tipo_Asi NOT IN (' + @TipoAsientoCierre + ') '
	END

	IF(@pId_Alias_Cta_Contable <> 0)
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND I.Id_Alias_Cta_Cont = ' + CONVERT(VARCHAR(10), @pId_Alias_Cta_Contable) + ' '
	END

	IF (@pFlag_Desglozar_CC = 0)
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) +
						'GROUP BY Id_Cta_Contable ORDER BY Id_Cta_Contable'
	ELSE
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) +
						'GROUP BY Id_Cta_Contable,Id_Centro_Costo ORDER BY Id_Cta_Contable,Id_Centro_Costo  '

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
		PRINT 'Saldos de asientos @SqlStr: '
		PRINT @SqlStr
		PRINT ''
	END

	EXECUTE sp_executesql @SqlStr

	--select * from #Asientos_Sumas_Saldos_ANTERIOR WHERE SALDO_ANT <> 0

	/*=============================================================================================================================*/

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
		PRINT 'COMPROBANTES'
	END

    Select Id_Cta_Contable,Id_Centro_Costo into  #Cbtes_Sumas_Saldos FROM  CBTES_CTAS_CONTABLES where 1=0

	ALTER TABLE #Cbtes_Sumas_Saldos ADD
	            Saldo_Ant						DECIMAL(30,2),
				Debe_Suma						DECIMAL(30,2),
				Haber_Suma						DECIMAL(30,2)

    Select Id_Cta_Contable,Id_Centro_Costo into  #Cbtes_Sumas_Saldos_ANTERIOR FROM  CBTES_CTAS_CONTABLES where 1=0
	ALTER TABLE #Cbtes_Sumas_Saldos_ANTERIOR ADD 
	            Saldo_Ant						DECIMAL(30,2),
				Debe_Suma						DECIMAL(30,2),
				Haber_Suma						DECIMAL(30,2)
	/*=============================================================================================================================*/

	SET @SqlStr = 'INSERT INTO #Cbtes_Sumas_Saldos (Id_Cta_Contable, Id_Centro_Costo, Saldo_Ant, Debe_Suma, Haber_Suma) '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr))												+ CHAR(13) + 
					'SELECT '															+ CHAR(13) + 
					'Id_Cta_Contable, '													+ CHAR(13)  
	IF (@pFlag_Desglozar_CC = 0)	
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) +		
					''''' as Id_Centro_Costo, '											+ CHAR(13)  
	ELSE
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) +		
					'ISNULL(I.Id_Centro_Costo,'''') as Id_Centro_Costo, '				+ CHAR(13) 
					 
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) +	
	                '0 as Saldo_ant, '									        		+ CHAR(13) + 
					'SUM(ISNULL(I.Debe,0)), '											+ CHAR(13) + 
					'SUM(ISNULL(I.Haber,0)) '											+ CHAR(13) + 
					'FROM Cbtes_Ctas_Contables I, Cbtes A, Cbtes_Tipos T '				+ CHAR(13) + 
					'WHERE '															+ CHAR(13) + 
					'A.Id_Trans = I.Id_Trans '											+ CHAR(13) + 
					'AND ISNULL(I.Id_Asiento, 0) = 0 '									+ CHAR(13) + 
					'AND A.Id_Tipo_Cbte = T.Id_Tipo_Cbte '								+ CHAR(13) + 
					'AND ISNULL(T.Compromete_Asientos, 0) <> 0 '						+ CHAR(13) + 
					'AND A.Id_Estado_Cbte <> 0'											+ CHAR(13) + 
					'AND A.Id_Estado_Cbte <> 3'

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND A.Periodo_Iva >= ''' + CONVERT(VARCHAR(10), @PCE_Fecha_Inicio, 112) + ''' '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND A.Periodo_Iva < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @PCE_Fecha_Cierre), 112) + ''' '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND A.Periodo_Iva >= ''' + CONVERT(VARCHAR(10), @pFecha_Desde, 112) + ''' '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND A.Periodo_Iva < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @pFecha_Hasta), 112) + ''' '

	IF(@pFlag_FiltrarId_CC <> 0)
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND I.Id_Centro_Costo = ''' + @pId_Centro_Costo + ''' '
	END

	IF(@pId_Unid_Negocio <> '')
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND T.Id_Unid_Negocio = ''' + @pId_Unid_Negocio + ''' '
	END

	IF(@pId_Alias_Cta_Contable <> 0)
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND I.Alias = ' + CONVERT(VARCHAR(10), @pId_Alias_Cta_Contable) + ' '
	END

	IF (@pFlag_Desglozar_CC = 0)
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) +
						'GROUP BY Id_Cta_Contable ORDER BY Id_Cta_Contable'
	ELSE
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) +
						'GROUP BY Id_Cta_Contable,I.Id_Centro_Costo ORDER BY Id_Cta_Contable,I.Id_Centro_Costo  '

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
		PRINT '@SqlStr: '
		PRINT @SqlStr
		PRINT ''
	END

	IF (@pFlag_incluirSoloAsientos = 0)       -- Si es solo asientos, no lo ejecuto
		EXECUTE sp_executesql @SqlStr
	
 --   SELECT * FROM #Cbtes_Sumas_Saldos
--------------SALDO ANTERIOR CBTES

	SET @SqlStr = 'INSERT INTO #Cbtes_Sumas_Saldos_ANTERIOR (Id_Cta_Contable, Id_Centro_Costo, Saldo_Ant,Debe_Suma,Haber_Suma) '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr))												+ CHAR(13) + 
					'SELECT '															+ CHAR(13) + 
					'Id_Cta_Contable, '													+ CHAR(13)  
	IF (@pFlag_Desglozar_CC = 0)	
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) +		
					''''' as Id_Centro_Costo, '											+ CHAR(13)  
	ELSE
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) +		
					'ISNULL(I.Id_Centro_Costo,'''') as Id_Centro_Costo, '				+ CHAR(13) 
					 
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) +	
					'SUM(ISNULL(I.Debe,0)-ISNULL(I.Haber,0)) as saldo_Ant, '			+ CHAR(13) + 
					'0 as Debe_Suma,'		    				+ CHAR(13) + 
					'0 as Haber_Suma'		    				+ CHAR(13) + 
					'FROM Cbtes_Ctas_Contables I, Cbtes A, Cbtes_Tipos T '				+ CHAR(13) + 
					'WHERE '															+ CHAR(13) + 
					'A.Id_Trans = I.Id_Trans '											+ CHAR(13) + 
					'AND ISNULL(I.Id_Asiento, 0) = 0 '									+ CHAR(13) + 
					'AND A.Id_Tipo_Cbte = T.Id_Tipo_Cbte '								+ CHAR(13) + 
					'AND ISNULL(T.Compromete_Asientos, 0) <> 0 '						+ CHAR(13) + 
					'AND A.Id_Estado_Cbte <> 0'											+ CHAR(13) + 
					'AND A.Id_Estado_Cbte <> 3'


	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND A.Periodo_Iva >= ''' + CONVERT(VARCHAR(10), @PCE_Fecha_Inicio, 112) + ''' '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND A.Periodo_Iva < ''' + CONVERT(VARCHAR(10), @pFecha_Desde, 112) + ''' '

	IF(@pFlag_FiltrarId_CC <> 0)
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND I.Id_Centro_Costo = ''' + @pId_Centro_Costo + ''' '
	END

	IF(@pId_Unid_Negocio <> '')
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND T.Id_Unid_Negocio = ''' + @pId_Unid_Negocio + ''' '
	END

	IF(@pId_Alias_Cta_Contable <> 0)
	BEGIN
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
						'AND I.Alias = ' + CONVERT(VARCHAR(10), @pId_Alias_Cta_Contable) + ' '
	END

	IF (@pFlag_Desglozar_CC = 0)
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) +
						'GROUP BY Id_Cta_Contable ORDER BY Id_Cta_Contable'
	ELSE
		SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) +
						'GROUP BY Id_Cta_Contable,I.Id_Centro_Costo ORDER BY Id_Cta_Contable,I.Id_Centro_Costo  '

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
		PRINT '@SqlStr: '
		PRINT @SqlStr
		PRINT ''
	END

	IF (@pFlag_incluirSoloAsientos = 0)       -- Si es solo asientos, no lo ejecuto
		EXECUTE sp_executesql @SqlStr

--		select * from #Cbtes_Sumas_Saldos_ANTERIOR

--------

   INSERT INTO  #Asientos_Sumas_Saldos  
        SELECT * FROM  #Cbtes_Sumas_Saldos

   INSERT INTO  #Asientos_Sumas_Saldos_ANTERIOR  
        SELECT * FROM  #Cbtes_Sumas_Saldos_ANTERIOR 
		
 

   SELECT ID_CTA_CONTABLE,ID_CENTRO_COSTO,SUM(SALDO_ANT) AS ANTERIOR ,SUM(Debe_Suma) AS Debe_Suma ,SUM(Haber_Suma) AS Haber_Suma
			INTO #Sumas_Saldos
			FROM #Asientos_Sumas_Saldos
			GROUP BY ID_CTA_CONTABLE,ID_CENTRO_COSTO
   --select count(*) from #Sumas_Saldos

   SELECT ID_CTA_CONTABLE,ID_CENTRO_COSTO,SUM(SALDO_ANT) AS ANTERIOR ,SUM(Debe_Suma) AS Debe_Suma ,SUM(Haber_Suma) AS Haber_Suma
			INTO #Sumas_Saldos_Anteriores
			FROM #Asientos_Sumas_Saldos_ANTERIOR
			GROUP BY ID_CTA_CONTABLE,ID_CENTRO_COSTO

   --select count(*) from #Sumas_Saldos_Anteriores
  
    SELECT Q.ID_CTA_CONTABLE,Q.ID_CENTRO_COSTO
		,SUM(Q.ANTERIOR) AS ANTERIOR
		,SUM(Q.Debe_Suma) AS Debe_Suma
		,SUM(Q.Haber_Suma) AS Haber_Suma
		into #Resultado
	FROM
			(
			SELECT a.ID_CTA_CONTABLE,a.ID_CENTRO_COSTO,a.ANTERIOR,a.Debe_Suma,a.Haber_Suma
			FROM #Sumas_Saldos_Anteriores A
			union 
			SELECT S.ID_CTA_CONTABLE,s.ID_CENTRO_COSTO,s.ANTERIOR,s.Debe_Suma,s.Haber_Suma
			FROM #Sumas_Saldos s
			) Q
	GROUP BY Q.ID_CTA_CONTABLE,Q.ID_CENTRO_COSTO
	ORDER BY Q.ID_CTA_CONTABLE,Q.ID_CENTRO_COSTO
	
	

	SELECT P.Nro_Cta_Contable,P.Alias,P.Descripcion as Cta_Contable, A.Id_Centro_Costo, C.Descripcion as Centro_Costo, P.Columna as Columna_Bal,P.Id_Cuenta_Padre as Alias_Cta_Padre,P.Id_Cta_Contable
	       into #Rpt_Balance_Sumas_Saldos 
		   from Pla_Ctas_Cuentas_Contables P, #Resultado A, Centro_Costos C
		   where P.Id_Plan_Cta = @pId_Plan_Cta
		   AND A.Id_Centro_Costo = C.Id_Centro_Costo
		   AND P.Id_Cta_Contable = A.ID_CTA_CONTABLE
		   AND A.Id_Cta_Contable IS NOT NULL
		   AND P.Id_Cta_Contable IS NOT NULL
		   
 
 
	SELECT P.Nro_Cta_Contable,P.Alias,P.Descripcion as Cta_Contable,SUM(P.columna) as columna_bal
	       into #CtaPadre 
		   from Pla_Ctas_Cuentas_Contables P, #Rpt_Balance_Sumas_Saldos A 
		   where P.Id_Plan_Cta = @pId_Plan_Cta
		   AND P.ALIAS = A.Alias_Cta_Padre
		   AND A.Alias_Cta_Padre <> 0
		   AND A.Id_Cta_Contable IS NOT NULL
		   AND P.Id_Cta_Contable IS NOT NULL	
		   GROUP BY P.Nro_Cta_Contable,P.Alias,P.Descripcion
		   
    
		   
	INSERT INTO	 #Rpt_Balance_Sumas_Saldos (Nro_Cta_Contable,Alias,Cta_Contable,Columna_Bal,Alias_Cta_Padre,Id_Cta_Contable,Id_Centro_Costo,Centro_Costo) 
	 SELECT Nro_Cta_Contable,Alias,Cta_Contable,0,0,0,'','' FROM #CtaPadre WHERE Cta_Contable NOT IN (SELECT Cta_Contable FROM #Rpt_Balance_Sumas_Saldos)
		   	
	ALTER TABLE #Rpt_Balance_Sumas_Saldos ADD
		Anterior						DECIMAL(30,2),
		Debe							DECIMAL(30,2),
		Haber							DECIMAL(30,2),
		Diferencia						DECIMAL(30,2),
		Deudor							DECIMAL(30,2),
		Acreedor						DECIMAL(30,2)

    UPDATE #Rpt_Balance_Sumas_Saldos 
			SET Anterior	    = 0,
				Debe			= 0,
				Haber			= 0,
				Diferencia		= 0,
				Deudor	        = 0,
				Acreedor        = 0 

	UPDATE #Rpt_Balance_Sumas_Saldos 
		SET Anterior    = a.ANTERIOR,
		Debe			= A.Debe_Suma,
		Haber			= A.Haber_Suma,
		Diferencia		= (A.Debe_Suma - A.Haber_Suma) 
        from #Rpt_Balance_Sumas_Saldos B, #Resultado A
	    where B.Id_Cta_Contable = A.Id_Cta_Contable
	          And B.Id_Centro_Costo = A.Id_Centro_Costo

    UPDATE #Rpt_Balance_Sumas_Saldos SET Deudor = abs(Diferencia+Anterior) where Diferencia+Anterior > 0

	UPDATE #Rpt_Balance_Sumas_Saldos SET Acreedor = abs(Diferencia+Anterior) where Diferencia+Anterior <= 0

	/*=============================================================================================================================*/

	SELECT * FROM #Rpt_Balance_Sumas_Saldos	
			WHERE 
			ISNULL(Debe, 0) <> 0 
			OR ISNULL(Haber, 0) <> 0
			OR ISNULL(Anterior, 0) <> 0
			OR COLUMNA_BAL = 0
			ORDER BY Nro_Cta_Contable,Centro_Costo
	
	/*=============================================================================================================================*/
	DROP TABLE #Asientos_Sumas_Saldos	
	DROP TABLE #Sumas_Saldos_Anteriores
	DROP TABLE #Cbtes_Sumas_Saldos
	DROP TABLE #Sumas_Saldos
  	DROP TABLE #Resultado
	DROP TABLE #Rpt_Balance_Sumas_Saldos
	DROP TABLE #Cbtes_Sumas_Saldos_ANTERIOR
	DROP TABLE #Asientos_Sumas_Saldos_ANTERIOR
	DROP TABLE #CtaPadre
	/*=============================================================================================================================*/
	
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Balance_Sumas_Saldos_Rpt'
	END
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	RETURN 9999
END CATCH

RETURN 0

/*

EXEC dbo.CPJ_Balance_Sumas_Saldos_Rpt '{
										"ModoDebug":"1",
										"Id_Usuario":"-1",
										"Fecha_Desde":"20210501",
										"Fecha_Hasta":"20210531",
										"Flag_incluirSoloAsientos":"0",
										"Flag_FiltrarId_CC":"0",
										"Id_Centro_Costo":"0",
										"Id_Plan_Cta":"3",
										"Id_Unid_Negocio":"",
										"Flag_Desglozar_CC":"0",
										"Flag_Excluir_Asientos_Cierre":"0"
										}'

EXEC dbo.CPJ_Balance_Sumas_Saldos_Rpt '{
										"ModoDebug":"1",
										"Id_Usuario":"-1",
										"Fecha_Desde":"20220101",
										"Fecha_Hasta":"20221101",
										"Flag_incluirSoloAsientos":"0",
										"Flag_FiltrarId_CC":"0",
										"Id_Centro_Costo":"0",
										"Id_Plan_Cta":"143",
										"Id_Unid_Negocio":"",
										"Flag_Desglozar_CC":"0",
										"Flag_Excluir_Asientos_Cierre":"0",
										"Id_Alias_Cta_Contable":""
										}'
										
										
*/
